﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ReferralContactLogs : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
            HiddenFieldClearFlag.Value = "0";
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "All Contacts";
    }

    public override string AppObjectCode()
    {
        return "EFR_CONTACTLOGS";
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxSearchCriteria.Text = String.Empty;
        HiddenFieldClearFlag.Value = "1";

    }

    protected void ButtonOK_Clear(object sender, EventArgs e)
    {
        GridViewEFRReferralContacts.PageIndex = 0;
        HiddenFieldClearFlag.Value = "0";

    }

    public void Contacts_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRReferralContacts.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRReferralContacts.SelectedValue);
            //calling the right page for different order lab order type
            Response.Redirect(string.Format("ReferralContactLog.aspx?referralId={0}", id));


        }

    }
}



